/*
to compile the sources:
on DOS prompt: cl65 -v -Oirs -C othello.cfg othello3.c othello_asm.s -o othello.prg
to run: sys 16384
exomizer sfx $4000 othello.prg -o othello-exo.prg -n
*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "othello.h"

#define uchar unsigned char
#define uint unsigned int
#define slint long int
#define ulint unsigned long int
#define POKE(addr,val) (*(unsigned char*) (addr) = (val))
#define PEEK(addr) (*(unsigned char*) (addr))
#define VI 0xd000
#define SI 0xd400
#define MV 0x0400
#define MC 0xd800
#define CHARSETBASEADDR 0x2000
#define SPRITE 0x3800//8192 

unsigned char spriteRawData[64] = {
	0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0x80, 0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80,
	0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80,
	0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80,
	0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80, 0xC0, 0x01, 0x80, 0xFF, 0xFF, 0x80,
	0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05
};




char time[13];
uint hour=0xdc0b;        // todhour
uint min=0xdc0a;         // todmin
uint sec=0xdc09;         //todsec
uint ten=0xdc08;         // todten
//   uint screen = 1238;
uint h,h1,m,s,te; 

const int ALLDIRECTIONS[8]={-11, -10, -9, -1, 1, 9, 10, 11};
const int BOARDSIZE=100;

const int EMPTY=0;   
const int BLACK=1;
const int WHITE=2;
const int OUTER=3;           /* the value of a square on the perimeter */

const long int WIN=2000;          /* a WIN and LOSS for player are outside  */
const long int LOSS= -2000;       /* the range of any board evaluation function */

long int BOARDS;

int human (int, int *);
int randomstrategy(int, int *);
int maxdiffstrategy1(int, int *); 
int maxdiffstrategy3(int, int *);
int maxdiffstrategy5(int, int *);
int maxweighteddiffstrategy1(int, int *);
int maxweighteddiffstrategy3(int, int *);
int maxweighteddiffstrategy5(int, int *);
int maxchoice (int, int *, int, int (*) (int, int *)); 
int minchoice (int, int *, int, int (*) (int, int *)); 
int minchoice (int, int *, int, int (*) (int, int *)); 

int X=1;   //coordinata x selezionata
int Y=1;   //coordinata y selezionata
int p1, p2; 
char x, y;
//int address;
//uchar Lo, Hi;

void * STRATEGIES[6][4] = {
   {"human", "human", human},
   {"random", "easy", randomstrategy},
   {"diff1", "medium", maxdiffstrategy1},
//   {"diff3", "maxdiff 3", maxdiffstrategy3},
//   {"diff5", "maxdiff 5", maxdiffstrategy5},
   {"wdiff1","hard", maxweighteddiffstrategy1},
   {"wdiff3","very hard", maxweighteddiffstrategy3},
//   {"wdiff5","maxweigt5", maxweighteddiffstrategy5},
   {NULL, NULL, NULL}
 };

char NAMEPLAYER[2]={6,1};

typedef int (* fpc) (int, int *);

int check_help (void);
int check_p1(void);
int check_p2(void);
uchar DecimalToBCD (char decimalByte);
uchar BCDToDecimal(char bcdByte);
void set_TOD(void);
void read_TOD(void);
//void LoHi( int integer);
void stampa_front_end(void);
void stampa_tabella(void);
int input(void);
void spriteEnable(void);
char  colorPlayer (int player);
int opponent (int player);
int * copyboard (int * board);
int * initialboard (void);
int count (int player, int * board);
void printboard (int * board);
int validp (int move);
int findbracketingpiece(int square, int player, int * board, int dir);
int wouldflip (int move, int player, int * board, int dir);
int legalp (int move, int player, int * board);
void makeflips (int move, int player, int * board, int dir);
void makemove (int move, int player, int * board);
int anylegalmove (int player, int * board);
int nexttoplay (int * board, int previousplayer, int cprintflag);
int * legalmoves (int player, int * board);
int human (int player,int * board);
int randomstrategy(int player, int * board);
int diffeval (int player, int * board);
int weighteddiffeval (int player, int * board);
int minmax (int player, int * board, int ply, int (* evalfn) (int, int *));
int maxchoice (int player, int * board, int ply, int (* evalfn) (int, int *));
int minchoice (int player, int * board, int ply, int (* evalfn) (int, int *));
int maxdiffstrategy1(int player, int * board);
int maxdiffstrategy3(int player, int * board);
int maxdiffstrategy5(int player, int * board);
int maxweighteddiffstrategy1(int player, int * board);
int maxweighteddiffstrategy3(int player, int * board);
int maxweighteddiffstrategy5(int player, int * board);
void getmove (int (* strategy) (int, int *), int player, int * board,int cprintflag);
void othello (int (* blstrategy) (int, int *),int (* whstrategy) (int, int *), int cprintflag);
int * randomboard (void);
void playgame (void);

/************************************************************************
******************************** MAIN ***********************************
************************************************************************/

int main (void) {

 
 char c;
 __asm__ ("lda #$fa"); 
 __asm__ ("sta $0328");
 screensize (&x, &y);
 
//bordercolor (8);
//bgcolor (8);
cursor(0);
textcolor(1);

  do {
	   reset_irq();
	   stampa_front_end();
	  
	   c=0;
	   POKE ((VI+0x15),0);
	   clrscr();
	   stampa_tabella();
	   
	   do{
	   gotoxy(27,6);
	   cprintf("p-play");
	   gotoxy(27,7);
	   cprintf("h-help");
	   gotoxy(27,8);
	   cprintf("c-credits");}
	   while(check_help());
	   
       playgame();
	   gotoxy(27,5);
	   textcolor(2);
       cprintf("press fire");
	   textcolor(1);
	   
//	   do{c=cgetc();}
//	   while(c!=' ');
	   while(num!=5)read_joy();
       num=0;
    }while(1); //while (c == ' ');

//	__asm__ ("jmp $fce2");
//	     gotoxy(26,15);
//       cprintf("             "); 
	return 0;

}

int check_p1(void){

switch(cgetc())
    {
		case '0':
            p1=0;
			return 0;
			break;
        case '1':
            p1=1;
			return 0;
			break;
        case '2':
			p1=2;
			return 0;
			break;
        case '3':
			p1=3;
			return 0;
			break;
		case '4':
			p1=4;
			return 0;
			break;
        
        default:
            //clrscr(); 
			return 1;
    }		
}	
int check_p2(void){

switch(cgetc())
    {
		case '0':
            p2=0;
			return 0;
			break;
        case '1':
            p2=1;
			return 0;
			break;
        case '2':
			p2=2;
			return 0;
			break;
        case '3':
			p2=3;
			return 0;
			break;
		case '4':
			p2=4;
			return 0;
			break;
       
        default:
            //clrscr(); 
			return 1;
    }		
}
int check_help (void){
		switch(cgetc()){
		case 'p':
		return 0;
		
		case 'c':
            clrscr();
			gotoxy((x-strlen("hotello revenge"))/2,1);
			textcolor(2);
			cprintf("othello revenge\r\n\n");
			textcolor(5);
			cprintf("credits:\r\n\n");
			textcolor(1);
			cprintf("programming:       ");
			textcolor(7);
			cprintf("matteo angelini\r\n");
			textcolor(1);
			cprintf("music and graphic: ");
			textcolor(7);
			cprintf("richard bayliss\r\n\n");
			textcolor(1);
			cprintf("original c source at:\r\n");
			textcolor(3);
			cprintf("https://github.com/petersieg/c/blob/master/othello.c\r\n\n");  
			textcolor(1);
			cprintf("i would thanks:\r\n");
			textcolor(7);
			cprintf("richard bayliss: ");
			textcolor(1);
			cprintf("for long and prolific\r\n"); 
			cprintf("                 productions\r\n\n");
			cprintf("the authors of:\r\n"); 
			textcolor(4);
			cprintf("cc65 suite\r\ncodebase64.org\r\ncharpad\r\nnotepad++\r\nvice team\r\nmapping the c64 book\r\n"); 
			textcolor(1);
			gotoxy((x-strlen("- press a key -"))/2,24);
			cprintf("- press a key -");
			cgetc();
			stampa_tabella();
            return 1;
			
        case 'h':
            clrscr();
			gotoxy((x-strlen("how to play"))/2,1);
			textcolor(2);
			cprintf("how to play\r\n\n");
			textcolor(1);
			
			cprintf("each piece played ");
			textcolor(7);			
			cprintf("must be laid adjacent\r\n"); 
			cprintf("to an opponent's piece");
			textcolor(1);
			cprintf(" so that the\r\n"); 
			cprintf("opponent's piece or a row of opponent's\r\n");  
			cprintf("pieces is flanked by the new piece and\r\n"); 
			cprintf("another piece of the player's colour.\r\n");  
			cprintf("all of the opponent's pieces between\r\n");  
			cprintf("these two pieces are 'captured'\r\n"); 
			cprintf("and turned over to match the player's\r\n");  
			cprintf("colour. it can happen that more\r\n");
			cprintf("than one direction are trapped between\r\n"); 
			cprintf("the new piece played and other pieces\r\n"); 
			cprintf("of the same colour.\r\n"); 
			cprintf("in this case, all the pieces in all\r\n");  
			cprintf("viable directions are turned over.\r\n");
			textcolor(7);
			cprintf("the game is over when neither player\r\n");  
			cprintf("has a legal move ");
			textcolor(1);
			cprintf("-i.e. a move that\r\n");  
			cprintf("captures at least one opposing piece- \r\n"); 
			textcolor(7);
			cprintf("or when the board is full.\r\n");
			textcolor(3);
			cprintf("in 'very hard' mode the computer can\r\n");
			cprintf("take very long time for moving!\r\n");
			textcolor(1);
			gotoxy((x-strlen("- press a key -"))/2,24);
			cprintf("- press a key -");
			cgetc();
			stampa_tabella();
            return 1;
        default:
            //clrscr(); 
			return 1;
    }
    //sprintf(impostazioni,"mode con: cols=%d lines=%d",larghezza*4+2,altezza*2+10);
    return 0;
}

char BCDToDecimal (char bcdByte)
{
  return (((bcdByte & 0xF0) >> 4) * 10) + (bcdByte & 0x0F);
}

char DecimalToBCD (char decimalByte)
{
  return (((decimalByte / 10) << 4) | (decimalByte % 10));
}

void set_TOD(void){
h=h1=m=s=te=0;
POKE(0xDC0E,(PEEK(0xDC0E)|0x80));  //set TOD
POKE(hour,h);
POKE(min,m);
POKE(sec,s);
POKE(ten,te);
}
 void read_TOD(void){
   h=BCDToDecimal(PEEK(hour)&0x7f);
   m=BCDToDecimal (PEEK(min));
   s=BCDToDecimal (PEEK(sec));
   te=BCDToDecimal (PEEK(ten));
   sprintf(time,"%02d:%02d:%02d",h,m,s);
}

/*
void LoHi( int integer)
 {
    Lo=integer&(0xff);
    Hi = (integer>>8) & 0xff;
 }
*/

void stampa_front_end(void){
int i;
memcpy((void*)(MV),(void*)&FRONT_END_MAP,1000);
makecolour1();
  
  POKE (2040,(SPRITE/64));		//set sprite pointers
  for (i=0;i<64;++i)POKE((SPRITE+i),spriteRawData[i]);
  
POKE ((VI+0x18),0x18);
POKE ((VI+0x16),0x18);
POKE ((VI+0x20),0x02);
POKE ((VI+0x21),0x0);
POKE ((VI+0x22),0x0B);
POKE ((VI+0x23),0x01);
setup_irq1();
//cgetc();
while(num!=5)read_joy();
num=0;
reset_irq();
reset_color();
}

void stampa_tabella(void){
memcpy((void*)(MV),(void*)&OTHELLO_MAP,0x3e8);
 //address=&OTHELLO_ATTRIBUTES;
 //LoHi(address);
makecolour();
POKE ((VI+0x21),0x0);
POKE ((VI+0x20),0x0);
POKE ((VI+0x21),0x0);
POKE ((VI+0x22),0x09);
POKE ((VI+0x23),0x01);
}



int input(void){	
	while(read_joy()!=5){
        if (num==3){
        X=(X==1)?1:--X;
		}
		
        if (num==4){
        X=(X==8)?8:++X;
		}
		
        if (num==1){
        Y=(Y==1)?1:Y=--Y;
		}
		
        if (num==2){
        Y=(Y==8)?8:++Y;
		}
		
//		POKE ((VI+16),0);
		POKE ((VI+0),24+7+20*(X-1)+4*(X-1));  //sprite   X
		POKE ((VI+1),50+8+20*(Y-1)+4*(Y-1));  //sprite   Y
	}
	    num=0;
        return (X+10*Y); 
}



void spriteEnable(void){
	POKE ((VI+21),PEEK(VI+21)|1); //sprite enable
	POKE ((VI+39),4);  //sprite color 0
	POKE ((VI+16),0x38);  //hight X bit
	POKE ((VI+0),24+8);  //sprite   X
	POKE ((VI+1),50+8);  //sprite   Y
}


char colorPlayer (int player){
	switch (player) {
	case 1: return NAMEPLAYER[0];
		break;
	case 2: return NAMEPLAYER[1];
		break;
	default: cprintf("illegal player"); 
	return 0;
	}
}



int opponent (int player) {
  switch (player) {
  case 1: return 2; 
  case 2: return 1;
  default: cprintf("illegal player"); 
  return 0;
  }
}


int * copyboard (int * board) {
  int i, * newboard;
  newboard = (int *)malloc(BOARDSIZE * sizeof(int));
  for (i=0; i<BOARDSIZE; i++) newboard[i] = board[i];
  return newboard;
}




int * initialboard (void) {
  int i, * board;
  board = (int *)malloc(BOARDSIZE * sizeof(int));
  for (i = 0; i<=9; i++) board[i]=OUTER;
  for (i = 10; i<=89; i++) {
     if (i%10 >= 1 && i%10 <= 8) board[i]=EMPTY; else board[i]=OUTER;
  }
  for (i = 90; i<=99; i++) board[i]=OUTER;
  board[44]=WHITE; board[45]=BLACK; board[54]=BLACK; board[55]=WHITE;
  return board;
}



int count (int player, int * board) {
  int i, cnt;
  cnt=0;
  for (i=1; i<=88; i++)
    if (board[i] == player) cnt++;
  return cnt;
}




void printboard (int * board) {
  int row, col, baseaddr, screenpos, colorpos, i, j=0;
  gotoxy(27,14);
  cprintf("            ");
  gotoxy(27,14);
  textcolor(colorPlayer(BLACK));
  cprintf("%c",36);
  textcolor(1);
  cprintf("=%d ",count(BLACK, board));
  textcolor(colorPlayer(WHITE));
  cprintf("%c",36);
  textcolor(1);
  cprintf("=%d ",count(WHITE, board));
  for (row=0; row<8; row++) {
	  i=0;
    for (col=0; col<8; col++){
	        baseaddr=41+40*(2*row+j)+(2*col+i);
			screenpos=MV+baseaddr;
			colorpos=MC+baseaddr;
			
	switch(board[(col+1)+10*(row+1)]){
		
		case 0: 
			POKE(colorpos,5);
			POKE(colorpos+1,5);
			POKE(colorpos+40,5);
			POKE(colorpos+41,5);

			POKE(screenpos,75);
			POKE(screenpos+1,76);
			POKE(screenpos+40,77);
			POKE(screenpos+41,78);
			break;
			
		case 1:
			POKE(colorpos,6);
			POKE(colorpos+1,6);
			POKE(colorpos+40,6);
			POKE(colorpos+41,6);

			POKE(screenpos,87);
			POKE(screenpos+1,88);
			POKE(screenpos+40,89);
			POKE(screenpos+41,90);
			break;		
			
		case 2: 
			POKE(colorpos,1);
			POKE(colorpos+1,1);
			POKE(colorpos+40,1);
			POKE(colorpos+41,1);

			POKE(screenpos,87);
			POKE(screenpos+1,88);
			POKE(screenpos+40,89);
			POKE(screenpos+41,90);
			break;			
			
		}
		i++;
	} 
	  j++;
}
}



int validp (int move) {
  if ((move >= 11) && (move <= 88) && (move%10 >= 1) && (move%10 <= 8))
     return 1;
  else return 0;
}



int findbracketingpiece(int square, int player, int * board, int dir) {
  while (board[square] == opponent(player)) square = square + dir;
  if (board[square] == player) return square;
  else return 0;
}

int wouldflip (int move, int player, int * board, int dir) {
  int c;
  c = move + dir;
  if (board[c] == opponent(player))
     return findbracketingpiece(c+dir, player, board, dir);
  else return 0;
}



int legalp (int move, int player, int * board) {
  int i;
  if (!validp(move)) return 0;
  if (board[move]==EMPTY) {
    i=0;
    while (i<=7 && !wouldflip(move, player, board, ALLDIRECTIONS[i])) i++;
    if (i==8) return 0; else return 1;
  }   
  else return 0;
}


void makeflips (int move, int player, int * board, int dir) {
  int bracketer, c;
  bracketer = wouldflip(move, player, board, dir);
  if (bracketer) {
     c = move + dir;
     do {
         board[c] = player;
         c = c + dir;
        } while (c != bracketer);
  }
}


void makemove (int move, int player, int * board) {
  int i;
  board[move] = player;
  for (i=0; i<=7; i++) makeflips(move, player, board, ALLDIRECTIONS[i]);
}




int anylegalmove (int player, int * board) {
  int move;
  move = 11;
  while (move <= 88 && !legalp(move, player, board)) move++;
  if (move <= 88) return 1; else return 0;
}



int nexttoplay (int * board, int previousplayer, int cprintflag) {
  int opp;
  opp = opponent(previousplayer);
  if (anylegalmove(opp, board)) return opp;
  if (anylegalmove(previousplayer, board)) {
    if (cprintflag) {
		gotoxy(27,7);
		textcolor(colorPlayer(opp));
		cprintf("%c ", 36);
		textcolor(1);
        cprintf("must pass");
		return previousplayer;}
  }
  return 0;
}


int * legalmoves (int player, int * board) {
  int move, i, * moves;
  moves = (int *)malloc(65 * sizeof(int));
  moves[0] = 0;
  i = 0;
  for (move=11; move<=88; move++) 
    if (legalp(move, player, board)) {
      i++;
      moves[i]=move;
    }
  moves[0]=i;
  return moves;
}


int human (int player,int * board) {
  int move;
  move=input();
 /*
//  gotoxy(25,1);
//  cprintf("%s move: %d", colorPlayer(player),move);
  gotoxy(26,22);
 
  cprintf("             ");
  gotoxy(26,22);
  cprintf("%s:%s",colorPlayer(player),STRATEGIES[p2][1]);
  */
  return move;
}


int randomstrategy(int player, int * board) {
  int r, * moves;
  moves = legalmoves(player, board);
  r = moves[(rand() % moves[0]) + 1];
  free(moves);
  return(r);
}


int diffeval (int player, int * board) { /* utility is measured */
  int i, ocnt, pcnt, opp;                /* by the difference in */
  pcnt=0; ocnt = 0;                      /* number of pieces */
  opp = opponent(player); 
  for (i=1; i<=88; i++) {
    if (board[i]==player) pcnt++;
    if (board[i]==opp) ocnt++;
  }
  return (pcnt-ocnt);
}



int weighteddiffeval (int player, int * board) {
  int i, ocnt, pcnt, opp;
  const int weights[100]={0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                          0,120,-20, 20,  5,  5, 20,-20,120,  0,
                          0,-20,-40, -5, -5, -5, -5,-40,-20,  0,
                          0, 20, -5, 15,  3,  3, 15, -5, 20,  0,
                          0,  5, -5,  3,  3,  3,  3, -5,  5,  0, 
                          0,  5, -5,  3,  3,  3,  3, -5,  5,  0, 
                          0, 20, -5, 15,  3,  3, 15, -5, 20,  0,
                          0,-20,-40, -5, -5, -5, -5,-40,-20,  0,
                          0,120,-20, 20,  5,  5, 20,-20,120,  0,
                          0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
  pcnt=0; ocnt=0;      
  opp = opponent(player);
  for (i=1; i<=88; i++) {
     if (board[i]==player) pcnt=pcnt+weights[i];
     if (board[i]==opp) ocnt=ocnt+weights[i];
  }
  return (pcnt - ocnt);
}




int minmax (int player, int * board, int ply, int (* evalfn) (int, int *)) {
  int i, max, ntm, newscore, bestmove, * moves, * newboard;
  
  moves = legalmoves(player, board); /* get all legal moves for player */
  max = LOSS - 1;  /* any legal move will exceed this score */
  for (i=1; i <= moves[0]; i++) {
    newboard = copyboard(board); BOARDS = BOARDS + 1;
    makemove(moves[i], player, newboard);
    ntm = nexttoplay(newboard, player, 0);
    if (ntm == 0) {  /* game over, so determine winner */
         newscore = diffeval(player, newboard);
         if (newscore > 0) newscore = WIN; /* a win for player */
         if (newscore < 0) newscore = LOSS; /* a win for opp */
    }
    if (ntm == player)   /* opponent cannot move */
       newscore = maxchoice(player, newboard, ply-1, evalfn);
    if (ntm == opponent(player))
       newscore = minchoice(player, newboard, ply-1, evalfn);
    if (newscore > max) {
        max = newscore;
        bestmove = moves[i];  /* a better move found */
    }
    free(newboard);
  }
  free(moves);
  return(bestmove);
}




int maxchoice (int player, int * board, int ply, 
               int (* evalfn) (int, int *)) {
  int i, max, ntm, newscore, * moves, * newboard;

  if (ply == 0) return((* evalfn) (player, board));
  moves = legalmoves(player, board);
  max = LOSS - 1;
  for (i=1; i <= moves[0]; i++) {
    newboard = copyboard(board); BOARDS = BOARDS + 1;
    makemove(moves[i], player, newboard);
    ntm = nexttoplay(newboard, player, 0);
    if (ntm == 0) {
         newscore = diffeval(player, newboard);
         if (newscore > 0) newscore = WIN;
         if (newscore < 0) newscore = LOSS;
    }
    if (ntm == player) 
       newscore = maxchoice(player, newboard, ply-1, evalfn);
    if (ntm == opponent(player))
       newscore = minchoice(player, newboard, ply-1, evalfn);
    if (newscore > max) max = newscore;
    free(newboard);
  }
  free(moves);
  return(max);
}



int minchoice (int player, int * board, int ply, 
               int (* evalfn) (int, int *)) {
  int i, min, ntm, newscore, * moves, * newboard;
  if (ply == 0) return((* evalfn) (player, board));
  moves = legalmoves(opponent(player), board);
  min = WIN+1;
  for (i=1; i <= moves[0]; i++) {
    newboard = copyboard(board); BOARDS = BOARDS + 1;
    makemove(moves[i], opponent(player), newboard);
    ntm = nexttoplay(newboard, opponent(player), 0);
    if (ntm == 0) {
         newscore = diffeval(player, newboard);
         if (newscore > 0) newscore = WIN;
         if (newscore < 0) newscore = LOSS;
    }
    if (ntm == player) 
       newscore = maxchoice(player, newboard, ply-1, evalfn);
    if (ntm == opponent(player))
       newscore = minchoice(player, newboard, ply-1, evalfn);
    if (newscore < min) min = newscore;
    free(newboard);
  }
  free(moves);
  return(min);
}



int maxdiffstrategy1(int player, int * board) { /* 1 ply lookahead */
  return(minmax(player, board, 1, diffeval));   /* diffeval as utility fn */
}

int maxdiffstrategy3(int player, int * board) { /* 3 ply lookahead */
  return(minmax(player, board, 3, diffeval));
}

int maxdiffstrategy5(int player, int * board) { /* 5 ply lookahead */
  return(minmax(player, board, 5, diffeval));
}


int maxweighteddiffstrategy1(int player, int * board) {
   return(minmax(player, board, 1, weighteddiffeval));
}

int maxweighteddiffstrategy3(int player, int * board) {
   return(minmax(player, board, 3, weighteddiffeval));
}

int maxweighteddiffstrategy5(int player, int * board) {
   return(minmax(player, board, 5, weighteddiffeval));
}


void getmove (int (* strategy) (int, int *), int player, int * board, 
              int cprintflag) {
  int move;
  if (cprintflag) printboard(board);
  move = (* strategy)(player, board);
  if (legalp(move, player, board)){
      if (cprintflag){gotoxy(27,5); 
					cprintf("            ");  
					gotoxy(26,7);
					cprintf("             "); 					
					gotoxy(27,5);
					
					cprintf("turn of ");
				//	gotoxy(27,6);
				    textcolor(colorPlayer(opponent(player)));
					cprintf("%c",36);
					textcolor(1);}
	
     makemove(move, player, board);
  }
  else {
	 gotoxy(26,7);
     cprintf("illegal move");

     getmove(strategy, player, board, cprintflag);
  }
}



void othello (int (* blstrategy) (int, int *), 
              int (* whstrategy) (int, int *), int cprintflag) {
  int * board;
  int player,i;
  char color;
  board = initialboard();
  set_TOD();
  player = BLACK;
  do {
    if (player == BLACK) getmove(blstrategy, BLACK, board, cprintflag);
    else getmove(whstrategy, WHITE, board, cprintflag);
    player = nexttoplay(board, player, cprintflag);
	read_TOD();
//	textcolor(7);
	gotoxy(27,16);
    cprintf("%s",time);
  }
  while (player != 0);
  if (cprintflag) {
	 gotoxy(27,7);
	 textcolor(4);
     cprintf("winner is ");
	 POKE(0x0400+9*40+31,87);
	 POKE(0x0400+9*40+32,88);
     POKE(0x0400+10*40+31,89);
	 POKE(0x0400+10*40+32,90);
	 
     color=(count(BLACK, board)>count(WHITE, board)?colorPlayer(BLACK):colorPlayer (WHITE));
	 POKE(0xd800+9*40+31,color);
	 POKE(0xd800+9*40+32,color);
     POKE(0xd800+10*40+31,color);
	 POKE(0xd800+10*40+32,color);
	 textcolor(1);
	 reset_irq1();
	 setup_irq3();
     printboard(board);

  }
}



int * randomboard (void) {
  int player, oldplayer, i, * board;
  board = initialboard();
  player = BLACK;
  i=1;
  do {
    if (player == BLACK) getmove(randomstrategy, BLACK, board, 0);
    else getmove(randomstrategy, WHITE, board, 0);
    oldplayer = player;
    player = nexttoplay(board, player, 0);
    if (oldplayer == player) {
       free(board);
       return(randomboard());
    }
    i++;
  }
  while (player != 0 && i<=8);
  if (player==0) {
     free(board);
     return(randomboard());
  }
  else return(board);
}


void playgame (void) {
 int i, cprintflag=1;
 int (* strfn1)(int, int *);  int (* strfn2)(int, int *);
 char * strnme;

 clrscr();

 stampa_tabella();
 setup_irq();
 
  /* get strategy for player 1 (black) from user */
  i=0;
  gotoxy(27,5);
  textcolor(7);
  cprintf("player 1: ");
  gotoxy(27,7);
  textcolor(2);
  cprintf("difficult: "); 
  textcolor(1);  
  while (STRATEGIES[i][0] != NULL) {
     strnme=STRATEGIES[i][1];
	 gotoxy(27,9+i);
	 cprintf("%d-%s", i, strnme);   
     i++;
  }

  //gotoxy(35,4);
  //cscanf("%d", &p1);
  while(check_p1());
  gotoxy(27,18);
  textcolor(7);
  cprintf("player1 ");
  textcolor(colorPlayer(BLACK));
  cprintf("%c",36);  //colorPlayer(BLACK));
  textcolor(1);
  gotoxy(27,19);
  cprintf("%s",STRATEGIES[p1][1]);

 /* get strategy for player 2 (white) from user */
  i=0;
  gotoxy(27,5);
  textcolor(7);
  cprintf("player 2: ");
   gotoxy(27,7);
   textcolor(1);
  cprintf("difficult: "); 
  while (STRATEGIES[i][0] != NULL) {
     strnme=STRATEGIES[i][1]; 
	 gotoxy(27,9+i);
	 cprintf("%d-%s", i, strnme);
     i++;
  }
  //gotoxy(35,4);
  //cscanf("%d", &p2);
  while(check_p2());
  gotoxy(27,20);
  textcolor(7);
  cprintf("player2 "); //colorPlayer(WHITE));
  textcolor(colorPlayer(WHITE));
  cprintf("%c",36);
  textcolor(1);
  gotoxy(27,21);
  cprintf("%s",STRATEGIES[p2][1]);
  
  for(i=0;i<12;i++) {
	 gotoxy(27,5+i);
	 cprintf("            ");
  }
  
  strfn1 = STRATEGIES[p1][2]; strfn2 = STRATEGIES[p2][2];
  
  if(p1==0||p2==0)spriteEnable();
	else POKE ((VI+21),PEEK(VI+21)&0xfe);
  
  othello(strfn1, strfn2, cprintflag);
}




    


