
SCREENRAM = $0400
COLORRAM = $d800
spritexpos = 0;  24
spriteypos = 50+8*23	;sprite y-position

spritedata  = $3800
spritedata1 = $3a00

.segment "LOADADDR"
		.byte 01,08
		
			.segment "MUSIC"
			.incbin "I_Love_DMC.sid",$7e

			.export _OTHELLO_CHARSET
			.segment "CHARSET"
_OTHELLO_CHARSET: 
			.incbin "frontEndCharset.bin"
			
;			.export _FRONT_END_CHARSET
;			.segment "FRONT_END_CHARSET"
;_FRONT_END_CHARSET: 
;			.incbin "frontEndCharset.bin"
			
			.export _FRONT_END_MAP
			.segment "FRONT_END_MAP"
_FRONT_END_MAP:	.incbin "frontEndMap.bin"

				.export _OTHELLO_MAP
				.segment "MAP"
_OTHELLO_MAP:	.incbin "othellomap.bin"
			
				.export _OTHELLO_ATTRIBUTES
				.segment "ATTRIBUTES"
 _OTHELLO_ATTRIBUTES:	.incbin "othello_attribs.bin"
 
			.export _FRONT_END_ATTRIBUTES
			.segment "FRONT_END_ATTRIBUTES"
_FRONT_END_ATTRIBUTES:	.incbin "frontEndAttributes.bin"

			.export _SPRITES_DATA
			.segment "SPRITES_DATA"
_SPRITES_DATA:	.incbin "spritesData.bin"

.segment "CODE"
;---------------------------------------------------------------------------------
;void makecolour(void);
;---------------------------------------------------------------------------------
.export _makecolour1
_makecolour1: 
			lda #<_FRONT_END_ATTRIBUTES
			ldx #>_FRONT_END_ATTRIBUTES	
			jsr copy
			rts
			
.export _makecolour
_makecolour: 
			lda #<_OTHELLO_ATTRIBUTES
			ldx #>_OTHELLO_ATTRIBUTES
			
copy:		sta $fb
			stx $fc
			ldx #$00
:			ldy SCREENRAM,x
			lda($fb),y
			sta $d800,x
			ldy SCREENRAM+$100,x
			lda($fb),y
			sta $d900,x
			ldy SCREENRAM+$200,x
			lda($fb),y
			sta $da00,x
			ldy SCREENRAM+$2e8,x
			lda($fb),y
			sta $dae8,x
			inx
			bne :-
			rts

;---------------------------------------------------------------------------------
;unsigned char read_joy(void);
;---------------------------------------------------------------------------------		  
			.export _read_joy
_read_joy:			
			lda $dc00 		;read joystick port 2
			lsr       		;get switch bits
			ror cup   		;switch_history = switch_history/2 + 128*current_switch_state
			lsr       		;cupdate the other switches' history the same way
			ror cdown
			lsr
			ror cleft
			lsr
			ror cright
			lsr
			ror button

			bit cup       ;check if the joystick has just been moved cup:
            bmi jp1   ;if not cup at all
            bvc jp1   ;or already cup during the last joystick readout	
            jmp movecup ;else it has just been tapped, thus react
		 
jp1:		bit cdown        
            bmi jp2    
            bvc jp2   			
			jmp movecdown
			
jp2:		bit cleft        
            bmi jp3    
            bvc jp3   			
			jmp movecleft

jp3:		bit cright       
            bmi jp4    
            bvc jp4   			
			jmp movecright

jp4:		bit button        
            bmi _read_joy    
            bvc _read_joy
			jmp pressbutton
		  
		  			
movecup:     
			
			lda #1
			sta _num
			rts
					
movecdown:  
			lda #2
			sta _num
		
			rts

movecleft:   
			lda #3
			sta _num
			rts

movecright:   
			lda #4
			sta _num
			rts

pressbutton: 
			lda #5
			sta _num
			rts


;---------------------------------------------------
;void setup__irq(void);
;---------------------------------------------------
;setup the irq runnnig in the main menu screen

			.export _setup_irq

_setup_irq:		
			sei
			lda #$7f
			sta $dc0d
			sta $dd0d
			lda $dc0d
			lda $dd0d
			lda #1
			sta $d01a
			lda #$1b
			sta $d011
			lda #<irq
			ldx #>irq
			ldy #$fa
			sta $314
			stx $315
			sty $d012
			asl $d019
			jsr $1000
;			lda #%00111110
;			sta $d010
			jsr init_text_pointer
			cli
			rts

;---------------------------------------------------
;void setup__irq1(void);
;---------------------------------------------------


			.export _setup_irq1

_setup_irq1:		
			sei
			lda #$7f
			sta $dc0d
			sta $dd0d
			lda $dc0d
			lda $dd0d
			lda #1
			sta $d01a
			lda #$1b
			sta $d011
			lda #<irq1
			ldx #>irq1
			ldy #$fa
			sta $314
			stx $315
			sty $d012
			jsr $1000
			asl $d019
			cli
			rts

;---------------------------------------------------
;void setup__irq3(void);
;---------------------------------------------------


			.export _setup_irq3

_setup_irq3:		
			sei
			lda #$7f
			sta $dc0d
			sta $dd0d
			lda $dc0d
			lda $dd0d
			lda #1
			sta $d01a
			lda #$1b
			sta $d011
			lda #<irq3
			ldx #>irq3
			ldy #$fa
			sta $314
			stx $315
			sty $d012
			jsr $1000
			lda #50
			sta gameOver
			jsr set_spr_pos0
			asl $d019
			cli
			rts
;---------------------------------------------------
;void reset__irq(void);
;---------------------------------------------------

.export _reset_irq

_reset_irq:		
			sei
			lda #$81
			sta $dc0d
			sta $dd0d
			lda #$00
			sta $d019
			sta $d01a
			sta $d015  ;sprite enable
			lda #$31
			sta $0314
			lda #$ea
			sta $0315
			jsr $1000
			cli
			rts

;---------------------------------------------------
;void reset__irq1(void);
;---------------------------------------------------

.export _reset_irq1

_reset_irq1:		
			sei
			lda #$81
			sta $dc0d
			sta $dd0d
			lda #$00
			sta $d019
			sta $d01a
			sta $d010
			sta $d015  ;sprite enable
			lda #$31
			sta $0314
			lda #$ea
			sta $0315
			jsr $1000
			cli
			rts		
;---------------------------------------------------
;interrupt handler
;---------------------------------------------------

irq: 
			asl $d019
			jsr $1003
			lda #<irq2
			ldx #>irq2
			ldy #$0
out1:		sta $314
			stx $315
			sty $d012
out3:		pla
			tay
			pla
			tax
			pla
			rti

irq2:       
			asl $d019
    		jsr spriteScroller
			jsr colorflash
     	    lda $dc01 ;wait for spacebar
            cmp #$ef
            bne nxt0
			lda toggle
			eor #1
			sta toggle
			
nxt0:		
			lda toggle
			bne nxt1
			jsr SCROLLCHARS	
nxt1:		lda #<irq
			ldx #>irq
			ldy #$fa
			sta $314
			stx $315
			sty $d012
			jmp $ea31
			
irq1: 
			asl $d019
			jsr $1003
			jsr colwash
			jsr colwashrev
			jmp $ea31

irq3: 
			asl $d019
			jsr $1003
			ldx gameOver
			clc
			lda #100
			adc sinetable,x 
			sta $d001
			sta $d003
			sta $d005
			sta $d007
			clc
			lda #100+24
			adc sinetable,x 
			sta $d009
			sta $d00b
			sta $d00d
			sta $d00f
			dec gameOver
			lda gameOver
			bne nxt2
			lda #50
			sta gameOver
nxt2:		jmp $ea31

;=========================================
;Scrolling chars in 8 different directions
;=========================================			

SCROLLCHARS:	
			jsr timedirection
			lda animchardelay 
			cmp #$01
			beq selectchartoscroll
			inc animchardelay
			rts 
selectchartoscroll:
			
			lda #$00
			sta animchardelay
			lda animchardirection
			cmp #0
			bne notnorth
			jsr scrollup 
			rts

notnorth:	cmp #1
			bne notnortheast
			jsr scrollup 
			jsr scrollright 
			rts 

notnortheast:
			cmp #2 
			bne noteast 
			jsr scrollright 
			rts 

noteast:	cmp #3
			bne notsoutheast
			jsr scrolldown
			jsr scrollright 
			rts 

notsoutheast:
			cmp #4
			bne notsouth 
			jsr scrolldown 
			rts 

notsouth:	
			cmp #5
			bne notsouthwest 
			jsr scrolldown
			jsr scrollleft
			rts 

notsouthwest:
			cmp #6
			bne notwest 
			jsr scrollleft 
			rts 

notwest:
			cmp #7
			bne notnorthwest 
			jsr scrollleft 
			jsr scrollup 
notnorthwest: 
			rts 


;Time direction of animated charset 

timedirection:
			lda animcharpointer 
			cmp #$ca ;Duration should be long enough here
			beq resetcharanimpointer 
			inc animcharpointer 
			rts 

resetcharanimpointer:
			lda #0 
			sta animcharpointer
			lda animchardirection 
			cmp #7
			beq resetanimcharto0
			inc animchardirection
			rts 
resetanimcharto0:
			lda #0
			sta animchardirection
			rts

scrolldown:
			jsr downlayer1a
			jsr downlayer1b 
			rts 

scrollup:	jsr uplayer1a 
			jsr uplayer1b
			rts 

scrollleft:
			jsr leftlayer 
			rts 
scrollright:
			jsr rightlayer
			rts 

uplayer1a:	lda $2000+(75*8)
			sta chartemp1
			lda $2000+(77*8)
			sta chartemp2
			ldx #$00
uploop1:	lda $2000+(75*8)+1,x 
			sta $2000+(75*8),x 
			inx 
			cpx #$07 
			bne uploop1
			lda chartemp2
			sta $2000+(75*8)+7 
			ldx #$00
uploop2:	lda $2000+(77*8)+1,x 
			sta $2000+(77*8),x 
			inx 
			cpx #$07
			bne uploop2 
			lda chartemp1
			sta $2000+(77*8)+7
			rts 

uplayer1b:	lda $2000+(76*8)
			sta chartemp3
			lda $2000+(78*8)
			sta chartemp4
			ldx #$00
uploop3:	lda $2000+(76*8)+1,x 
			sta $2000+(76*8),x 
			inx 
			cpx #$07
			bne uploop3
			lda chartemp4
			sta $2000+(76*8+7)
			ldx #$00
uploop4:	lda $2000+(78*8+1),x 
			sta $2000+(78*8),x 
			inx 
			cpx #$07 
			bne uploop4
			lda chartemp3
			sta $2000+(78*8)+7
			rts 

downlayer1a:
			lda $2000+(75*8)+7
			sta chartemp1
			lda $2000+(77*8)+7
			sta chartemp2
			ldx #$06 
tiledownloop1:
			lda $2000+(75*8),x 
			sta $2000+(75*8)+1,x 
			dex 
			bpl tiledownloop1
			lda chartemp2
			sta $2000+(75*8)
			ldx #$06 
tiledownloop2:
			lda $2000+(77*8),x 
			sta $2000+(77*8+1),x 
			dex 
			bpl tiledownloop2 
			lda chartemp1
			sta $2000+(77*8)
			rts 

downlayer1b:
			lda $2000+(76*8)+7 
			sta chartemp3
			lda $2000+(78*8)+7 
			sta chartemp4
			ldx #$06
tiledownloop3:
			lda $2000+(76*8),x 
			sta $2000+(76*8)+1,x 
			dex 
			bpl tiledownloop3 
			lda chartemp4 
			sta $2000+(76*8) 
			ldx #$06 
tiledownloop4:
			lda $2000+(78*8),x 
			sta $2000+(78*8)+1,x 
			dex 
			bpl tiledownloop4 
			lda chartemp3
			sta $2000+(78*8)
			rts 

leftlayer:	ldx #$00
scrlefta:	lda $2000+(75*8),x  
			asl 
			rol $2000+(76*8),x 
			rol $2000+(75*8),x 
			inx 
			cpx #$08
			bne scrlefta 
			ldx #$00
scrleftb:	lda $2000+(77*8),x 
			asl 
			rol $2000+(78*8),x 
			rol $2000+(77*8),x 
			inx 
			cpx #$08 
			bne scrleftb
			rts 

rightlayer:	ldx #$00
scright1:	lda $2000+(75*8),x 
			lsr 
			ror $2000+(76*8),x
			ror $2000+(75*8),x 
			inx 
			cpx #$08 
			bne scright1
			ldx #$00
scrright2:	lda $2000+(77*8),x 
			lsr 
			ror $2000+(78*8),x 
			ror $2000+(77*8),x 
			inx 
			cpx #$08 
			bne scrright2 
			rts 			

;=========================================
;	init text pointer
;=========================================
init_text_pointer:

		lda #<scroll_text
		sta $50
		lda #>scroll_text
		sta $51

;--------------------------------------------------
;----- Paragraph @clear sprite-memory@ -----
;--------------------------------------------------

		ldx #0
		lda #$00
		
loop4:	sta spritedata+64,x;$3800,x
		inx
		bne loop4
		ldx #0
		lda #$00
		
loop6:	sta spritedata+256+64,x;$3900,x
		inx
		cpx #64
		bne loop6
		
		ldx #0
		;lda #$ff
loop7:  sta spritedata+256+128,x;$3940,x
		inx
		cpx #128
		bne loop7
		

		ldx #7
		lda #0
loop5:	sta spritechar,x
		dex
		bpl loop5

;---------------------------------
;set_spr_pos1:
;---------------------------------

set_spr_pos1:		
;		lda #spritexpos
;		sta $d000
		lda #spritexpos+255-24
		sta $d002
		lda #spritexpos+255
		sta $d004
		lda #spritexpos+23
		sta $d006
		lda #spritexpos+24*2-1
		sta $d008
		lda #spritexpos+24*3-1
		sta $d00a
		lda #spriteypos
;		sta $d001
		sta $d003
		sta $d005
		sta $d007
		sta $d009
		sta $d00b
				
				
		lda #%00111000
		sta $d010
		
		lda #0
		sta $d01b   ;Sprite to Foreground Display Priority Register
		sta $d01c   ;Sprite Multicolor Registers
	    lda #1
;		sta $d027    ;Sprite 0 Color Register (the default color value is 1, white)
		sta $d028
		sta $d029
		sta $d02a
		sta $d02b
		sta $d02c
;		sta $d02d
;		sta $d02e

;		sprites at $3800

;		lda #spritedata/64
;		sta $07f8
		lda #spritedata/64+1
		sta $07f9
		lda #spritedata/64+2
		sta $07fa
		lda #spritedata/64+3
		sta $07fb
		lda #spritedata/64+4
		sta $07fc
		lda #spritedata/64+5
		sta $07fd
;	    lda #230
;		sta $07fe
;		lda #231
;		sta $07ff    ; set pointer: sprite data at $e80
		lda $d015
		ora #%00111110
		sta $d015
		rts	

;---------------------------------
;set_spr_pos0:
;---------------------------------
set_spr_pos0:
            lda #spritedata1/64
			sta $07f8
			lda #spritedata1/64+1
			sta $07f9
			lda #spritedata1/64+2
			sta $07fa
			lda #spritedata1/64+3
			sta $07fb
			lda #spritedata1/64+4
			sta $07fc
			lda #spritedata1/64+5
			sta $07fd
			lda #spritedata1/64+6
			sta $07fe
			lda #spritedata1/64+7
			sta $07ff
			lda #80
			sta $d000
			lda #80+24*1
			sta $d002
			lda #80+24*2
			sta $d004
			lda #80+24*3
			sta $d006
			lda #80+24*0
			sta $d008
			lda #80+24*1
			sta $d00a
			lda #80+24*2
			sta $d00c
			lda #78+24*3
			sta $d00e
			lda #120
			sta $d001
			sta $d003
			sta $d005
			sta $d007
			lda #120+24
			sta $d009
			sta $d00b
			sta $d00d
			sta $d00f

			lda #$ff
			sta $d015
;			sta $d01b   ;Sprite to Foreground Display Priority Register
			sta $d01c   ;Sprite Multicolor Registers
			lda #0
			sta $d025
			lda #1
			sta $d026
			lda #5
			sta $d027    ;Sprite 0 Color Register (the default color value is 1, white)
			sta $d028
			sta $d029
			sta $d02a
			sta $d02b
			sta $d02c
			sta $d02d
			sta $d02e
			rts
;===========================================
;spriteScroller:
;===========================================
spriteScroller:

		dec cnt+1
cnt:	lda #8			;already 8 pixel moved?
		beq neuchar		;if yes, read in new char
		jmp softscroll		;else jump to the softscroller and return to the main routine
				
neuchar:
	
		ldy #0		 ;read new char
		lda ($50),y	 ;this is the text-pointer
		jsr _pet2scr
		bne undlos	 ;end-sign?
				
 		lda #<scroll_text			;if yes, reset text-vector
 		sta $50
 		lda #>scroll_text
  		sta $51
		

undlos:	clc			;clear carry-bit
		rol			;char-value * 8
		rol			;(this is the offset for the pixeldata of a char in the charset)
		rol
		sta loop2+1
		bcc weiter
		inc loop2+2

weiter:	ldx #7			;read 8 bytes (one char from the charset)
loop2:	lda $2000,x		;from charset-memory
		sta spritechar,x  ;and store to that memory-adress where the char is located,
		dex			      ;that "roles" next into the spritescroll
		bpl loop2

		lda #0			;reset adresses
		sta loop2+1
		lda #$20
		sta loop2+2

		inc $50			;increase scrolltext-counter
		lda $50
		bne nixneu
		inc $51

nixneu:	lda #8			;reset scrolltext-counter
		sta cnt+1
		
;---------------------------
softscroll:	ldy #0
			ldx #0

loop1:	clc
origin:	
		rol spritechar	;"read" left bit of new sign
;		rol spritedata+64+322,x		;move sprite-char - sprite6
;		rol spritedata+64+321,x
;		rol spritedata+64+320,x
;		rol spritedata+64+258,x		;move sprite-char - sprite5
;		rol spritedata+64+257,x
		rol spritedata+64+256,x
		rol spritedata+64+194,x		;move sprite-char - sprite4
		rol spritedata+64+193,x
		rol spritedata+64+192,x
		rol spritedata+64+130,x		;move sprite-char - sprite3
		rol spritedata+64+129,x
		rol spritedata+64+128,x
		rol spritedata+64+66,x		;move sprite-char - sprite2
		rol spritedata+64+65,x
		rol spritedata+64+64,x
		rol spritedata+64+2,x		;move sprite-char - sprite1
		rol spritedata+64+1,x
		rol spritedata+64,x
		iny
		inc origin+1	;increase counter and set to next "pixel-row" of that char
		txa
		clc
		adc #3
		tax
		cpy #8
		bne loop1
		lda #<spritechar ;restore original value
		sta origin+1
		lda #>spritechar
	    sta origin+2

;		jmp $ea7e
		rts
		
;====================================================
;unsigned char __fastcall__ pet2scr(unsigned char);
;====================================================
			.export _pet2scr

_pet2scr:	eor #$e0
			clc
			adc #$20
			bpl cont
			adc #$40
			bpl cont
			eor #$a0
cont:		rts


;======================
;COLOUR FLASH ROUTINE
;======================
colorflash:    lda colourdelay 
			cmp #$03
			beq colourok 
			inc colourdelay 
			rts 
colourok:	lda #0
			sta colourdelay
			ldx tmp 
			lda colour,x 
			sta COLORRAM+80+29  
			sta COLORRAM+80+30
			sta COLORRAM+80+31
			sta COLORRAM+80+32
			sta COLORRAM+80+33
			sta COLORRAM+80+34 
			sta COLORRAM+80+35
			sta COLORRAM+120+29
			sta COLORRAM+120+30
			sta COLORRAM+120+31
			sta COLORRAM+120+32
			sta COLORRAM+120+33
			sta COLORRAM+120+34
			sta COLORRAM+120+35
			sta $d027
			sta $d028
			sta $d029
			sta $d02a
			sta $d02b
			sta $d02c
			inx 
			cpx #13
			beq resetcolourroutine
			inc tmp
			rts
resetcolourroutine:
			ldx #0
			stx tmp 
			rts 

;======================
;RESET COLOR ROUTINE
;======================

			.export _reset_color

_reset_color:		lda #0
					ldx #0
:					sta $d800,x
					sta $d900,x
					sta $da00,x
					sta $dae8,x
					inx
					bne :-
					rts
;======================
;COLOUR WASHING ROUTINE
;======================
colwash:             lda colour1
                     sta colour1+40
                     ldx #0
cycle:               lda colour1+1,x
                     sta colour1,x
                     lda colour1,x
                     sta COLORRAM+40,x
					 sta COLORRAM+40*23,x
                     inx
                     cpx #40
                     bne cycle
                     rts 

;======================
;COLOUR WASHING ROUTINE (REVERSED)
;======================
colwashrev:     lda colour2+40
				sta  colour2
				ldx #40
cycle1:      		lda colour2-1,x
				sta colour2,x
				lda colour2,x
				sta COLORRAM+11*40,x
				dex
				bne cycle1
				rts	

;======================
;waitframe 
;======================
waitframe: 
          lda $d012
          cmp #$ff
          beq waitframe

waitfr2:  
          lda $d012
          cmp #$ff
          bne waitfr2 
          rts				

spritechar:  .byte 0,0,0,0,0,0,0,0				
charanimdelay: .byte 0
animchardelay:	.byte 0
animchardirection: .byte 0
animcharpointer: .byte 0
chartemp1: .byte 0
chartemp2: .byte 0
chartemp3: .byte 0
chartemp4: .byte 0
colourdelay: .byte 0
tmp:		.byte 0,0,0

.export _num
_num:			.byte 0

gameOver:		.byte 0

cup:   			.byte 0
cdown:  	    .byte 0
cleft:  		.byte 0
cright:  		.byte 0
button: 	    .byte 0
toggle:			.byte 0


colour:      .byte 6,2,4,5,3,7,1,7,3,5,4,2,6,0
colour1:     .byte 5,5,3,3,7,7,1,1,7,7,3,3,5,5,6,6,5,5,3,3,7,7,1,1,7,7,3,3,5,5,6,6,5,5,3,3,7,7,1,1
colour2:     .byte 5,5,3,3,7,7,1,1,7,7,3,3,5,5,6,6,5,5,3,3,7,7,1,1,7,7,3,3,5,5,6,6,5,5,3,3,7,7,1,1,0,0
	 
scroll_text:
.byte  "  welcome to othello revenge, programming by matteo angelini       music and graphic by richard bayliss          "
.byte  "for istructions on how to play press 'h' at the beginning       "        
.byte  "some words about algoritm beahind level difficults:      easy is actually a random strategy by the computer,      "
.byte  "medium level: an algorithm calculate the move that offer the maximun numbers of pieces in a line,          hard level: an algorithm give  "
.byte  "a 'weight' at each table position i.e the border position have a weight highter then central table position.     "
.byte  "very hard level: is the same of hard level but calculate 3 look ahead moves. the computer may take over 10 minutes each move!         " 
.byte  "i have omitted to put strategy that calculate 5 look ahead moves because of very long calculation time at 1mhz clock cpu.         "
.byte  "for more information visit https://github.com/petersieg/c/blob/master/othello.c       " 
.byte 0

sinetable:	 
.byte 0,24,21,18,15,12,9,7,5,3,1,0,0,0,0,0,1
.byte 2,4,6,8,11,14,17,20,23,26,29,33,36,38,41,43
.byte 45,47,48,49,49,49,49,48,47,46,44,42,39,37,34,31
.byte 28,25,0